﻿namespace Microsoft.Samples.PlanMyNight.Data.Tests
{
    using System.Linq;
    using Microsoft.VisualStudio.TestTools.UnitTesting;

    [TestClass]
    public class ReferenceRepositoryFixture
    {
        [TestMethod]
        public void RetrieveStatesReturnsUsa50States()
        {
            var repo = new ReferenceRepository();
            var result = repo.RetrieveStates();

            Assert.IsNotNull(result);
            Assert.AreEqual(50, result.Count());
        }

        [TestMethod]
        [DeploymentItem("PlanMyNight.mdf")]
        public void RetrieveZipCodesForState()
        {
            var repo = new ReferenceRepository();
            var result = repo.RetrieveZipCodes("NY");

            Assert.IsNotNull(result);
            Assert.AreNotEqual(0, result.Count());
        }

        [TestMethod]
        [DeploymentItem("PlanMyNight.mdf")]
        public void RetrieveZipCodesForUnexistingStateReturnsEmpty()
        {
            var repo = new ReferenceRepository();
            var result = repo.RetrieveZipCodes("XX");

            Assert.IsNotNull(result);
            Assert.AreEqual(0, result.Count());
        }

        [TestMethod]
        [DeploymentItem("PlanMyNight.mdf")]
        public void RetrieveCitiesForState()
        {
            var repo = new ReferenceRepository();
            var result = repo.RetrieveCities("NY");

            Assert.IsNotNull(result);
            Assert.AreNotEqual(0, result.Count());
        }

        [TestMethod]
        [DeploymentItem("PlanMyNight.mdf")]
        public void RetrieveCitiesForUnexistingStateReturnsEmpty()
        {
            var repo = new ReferenceRepository();
            var result = repo.RetrieveCities("XX");

            Assert.IsNotNull(result);
            Assert.AreEqual(0, result.Count());
        }
    }
}
